/*------------------------------------------------------------------------------

    File    :   MPEGIMDA.h

    Author  :   Stphane TAVENARD

    $VER:   MPEGIMDA.h  0.0  (04/03/1997)

    (C) Copyright 1997-1997 Stphane TAVENARD
        All Rights Reserved

    #Rev|   Date   |                      Comment
    ----|----------|--------------------------------------------------------
    0   |04/03/1997| Initial revision                                     ST

    ------------------------------------------------------------------------

    MPEG IMDCT optimzed ! definitions

------------------------------------------------------------------------------*/

#ifndef MPEGIMDA_H
#define MPEGIMDA_H

#ifndef ASM

#ifdef _DCC
#define REG(x) __ ## x
#define ASM
#define SAVEDS __geta4
#else
#define REG(x) register __ ## x
#ifdef __MAXON__
#define ASM
#define SAVEDS
#else
#define ASM    __asm
#define SAVEDS __saveds
#endif
#endif

#endif

#ifndef HACK
void MPEGIMDA_hybrid( INT16 *in,
                      INT16 *out,
                      INT16 *prev,
                      INT16 block_type,
                      INT16 mixed,
                      INT16 sb_max );

#else
ASM void MPEGIMDA_hybrid( REG(a0) INT16 *in,
                          REG(a1) INT16 *out,
                          REG(a2) INT16 *prev,
                          REG(d0) INT16 block_type,
                          REG(d1) INT16 mixed,
                          REG(d2) INT16 sb_max );
#endif
#endif /* MPEGIMDA_H */
