/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id: mpa2wav.c,v 1.6 2005/03/01 14:39:01 linus Exp $
 *
 * Copyright (C) 2005 Dave Chapman
 *
 * All files in this archive are subject to the GNU General Public License.
 * See the file COPYING in the source tree root for full license agreement.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

#include "plugin.h"

#if (CONFIG_HWCODEC == MASNONE)
/* software codec platforms */

#include <codecs/cf-mpegdec/defs.h>
#include <codecs/cf-mpegdec/mpegdec.h>

#include "lib/xxx2wav.h" /* Helper functions common to test decoders */

static struct plugin_api* rb;
file_info_struct file_info;
static MPEGDEC_STREAM *mps = NULL;
INT16 pcm1[MPEGDEC_PCM_SIZE], pcm2[MPEGDEC_PCM_SIZE];
INT16 *pcm[2];
#define SHRT_MAX 32767
INT16 pcm_buffer[MPEGDEC_MAX_CHANNELS*MPEGDEC_PCM_SIZE];

#define INPUT_BUFFER_SIZE	(10*8192)
#define OUTPUT_BUFFER_SIZE	65536 /* Must be an integer multiple of 4. */

//unsigned char InputBuffer[INPUT_BUFFER_SIZE+MAD_BUFFER_GUARD];
//unsigned char OutputBuffer[OUTPUT_BUFFER_SIZE];
//unsigned char *OutputPtr=OutputBuffer;
//unsigned char *GuardPtr=NULL;
//const unsigned char *OutputBufferEnd=OutputBuffer+OUTPUT_BUFFER_SIZE;

#ifndef SIMULATOR
extern char iramcopy[];
extern char iramstart[];
extern char iramend[];
#endif

// Here start our own bitstream access routines

INT32 bs_open( char *stream_name, INT32 buffer_size, INT32 *stream_size )
/*-----------------------------------------------------------------------
*/
{
   // We don't really need stream_name
   // print it anyway...
   // buffer_size indicate the following read access size

   // printf( "bs_open: '%s'\n", stream_name );

   // initialize some variables
   file_info.curpos = 0;

   // We know total size, we can set it
   *stream_size = file_info.filesize;

   // Just return a dummy handle (not NULL)
   return 1;
}

void bs_close( INT32 handle )
/*---------------------------
*/
{
   if( handle ) {
      // Clean up
      // printf( "bs_close\n" );
   }
}

INT32 bs_read( INT32 handle, void *buffer, INT32 num_bytes )
/*----------------------------------------------------------
*/
{

   INT32 read_size;

   if( !handle ) return -1; // Check valid handle

   read_size = file_info.filesize - file_info.curpos;
   if( read_size > num_bytes ) read_size = num_bytes;

   if( read_size > 0 ) {
      if( !buffer ) return -1;
      // Fill buffer with our MPEG audio data
      memcpy( buffer, &filebuf[ file_info.curpos ], read_size );
      file_info.curpos += read_size;
   }
   else {
      read_size = -1; // End of stream
   }

   return read_size;
}

int bs_seek( INT32 handle, INT32 abs_byte_seek_pos )
/*-----------------------------------------------
*/
{
   if( !handle ) return -1;

   if( abs_byte_seek_pos <= 0 ) file_info.curpos = 0;
   else if( abs_byte_seek_pos >= file_info.filesize ) return -1;
   else file_info.curpos = abs_byte_seek_pos;
   return 0;
}

int output_pcm( INT16 channels, INT16*pcm[ 2 ], INT32 count, int out_file )
/*---------------------------------------------------------------------------
   Ouput the current decoded PCM to a file
   Return 0 if Ok
*/
{
//#define PCM_BUFFER_SIZE (MPEGDEC_MAX_CHANNELS*MPEGDEC_PCM_SIZE)
//   static INT16 *pcm_buffer = NULL;
//   if( !out_file ) return -1;

//   if( !pcm_buffer ) {
//      pcm_buffer = (INT16 *)malloc( PCM_BUFFER_SIZE * sizeof(INT16) );
//      if( !pcm_buffer ) return -1;
//   }
/*   if( channels == 2 ) {
      register INT16 *pcm0, *pcm1, *pcmLR;
      register INT32 i;
      INT16 sample;
      
      pcm0 = pcm[ 0 ];
      pcm1 = pcm[ 1 ];
      pcmLR = pcm_buffer;
      i = count;
      while( i-- ) {
         sample = *pcm0++;
         *pcmLR++ = ((sample&0xff) << 8) | ((sample&0xff00) >> 8);
         sample = *pcm1++;
         *pcmLR++ = ((sample&0xff) << 8) | ((sample&0xff00) >> 8);
      }
      rb->write( out_file, pcm_buffer, 4*count );
   }
   else {
      rb->write( out_file, pcm[ 0 ], 2*count );
   }

   return 0;

*/} /* output_pcm */

/* this is the plugin entry point */
enum plugin_status plugin_start(struct plugin_api* api, void* file)
{
  int Status=0;
  unsigned short Sample;
  int i;
  size_t ReadSize, Remaining;
  unsigned char  *ReadStart;
  INT32 pcm_count;

  /* Generic plugin inititialisation */

  TEST_PLUGIN_API(api);
  rb = api;
  pcm[0] = pcm1;
  pcm[1] = pcm2;
  
  static char *modes[] = { "stereo", "j-stereo", "dual", "mono" };

  MPEGDEC_ACCESS bs_access = { bs_open, bs_close, bs_read, bs_seek };

  MPEGDEC_CTRL mpa_ctrl = {
     NULL,    // Bitstream access is default file I/O
     // Layers I & II settings (#3)
     { FALSE, { 1, 2, 48000 }, { 1, 2, 48000 } },
     // Layer III settings (#3)
     { FALSE, { 1, 2, 48000 }, { 1, 2, 48000 } },
     0,           // #2: Don't check mpeg validity at start (needed for mux stream)
     2048         // #2: Stream Buffer size
  };

#ifndef SIMULATOR
  rb->memcpy(iramstart, iramcopy, iramend-iramstart);
#endif

  /* This function sets up the buffers and reads the file into RAM */

  if (local_init(file,"/cf-mpegdectest.wav",&file_info,api)) {
    return PLUGIN_ERROR;
  }

 //if error:   return PLUGIN_ERROR;

  file_info.start_tick=*(rb->current_tick);

  rb->button_clear_queue();

  mpa_ctrl.bs_access = &bs_access;

  mps = MPEGDEC_open( file, &mpa_ctrl );
  if( !mps ) {
     //printf( "Unable to open MPEG Audio stream '%s'\n", in_filename );
     //exit( 0 );
  }
  file_info.samplerate = 48000;
  //printf( "MPEG%d-%s %s %dkbps %dHz (%ld ms)\n",
  //        mps->norm, (mps->layer == 1)?"I":(mps->layer == 2)?"II":"III",
  //        modes[ mps->mode ], mps->bitrate, mps->frequency, mps->ms_duration );

  //printf( "Decoding: Channels=%d Quality=%d Frequency=%dHz\n",
  //         mps->dec_channels, mps->dec_quality, mps->dec_frequency ); // #3

  while( (pcm_count = MPEGDEC_decode_frame( mps, pcm )) >= 0 ) {
     output_pcm( mps->dec_channels, pcm, pcm_count, file_info.outfile );
     //frame++;
     file_info.frames_decoded++;
     file_info.current_sample += pcm_count;

     display_status(&file_info);

     if (rb->button_get(false)!=BUTTON_NONE) { 
       close_wav(&file_info);
       return PLUGIN_OK;
     }
    //fprintf( stderr, "{%04d}\r", frame ); fflush( stderr );
  }
  //fprintf( stderr, "\n" );

  MPEGDEC_close( mps );

  close_wav(&file_info);
  rb->splash(HZ*2, true, "FINISHED!");

  return PLUGIN_OK;
}
#endif /* CONFIG_HWCODEC == MASNONE */


static int break_cleanup( void )
{
   if( mps ) {
      MPEGDEC_close( mps );
      mps = NULL;
   }
   return 1;
}

static void exit_cleanup( void )
{
   (void)break_cleanup();
}

