#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <curl/curl.h>
#include <curl/easy.h>

#define BUF 5000000
char buffer[BUF];
int bptr;
char buf2[BUF];

size_t webline(void *ptr,size_t size,size_t n,void *userdata) {
  int i;
  char *t=(char *)ptr;
  for(i=0;t[i];i++) buffer[bptr++]=t[i];
  buffer[bptr]=0;
  return n;
}

void loadwebpage(char *url) {
  CURL *curl=curl_easy_init();
  CURLcode res;
  curl_easy_setopt(curl,CURLOPT_URL,url);
  curl_easy_setopt(curl,CURLOPT_WRITEFUNCTION,webline);
  bptr=0;
  res=curl_easy_perform(curl);
  curl_easy_cleanup(curl);
}

#define MAXP 10000
int num;
char taken[MAXP];

int fileexists(char *s) {
  FILE *f=fopen(s,"r");
  if(f) {
    fclose(f);
    return 1;
  }
  return 0;
}

int supported(char *s) {
/*  if(!strcmp(s,"nur")) return 1;
  if(!strcmp(s,"aka")) return 1;
  if(!strcmp(s,"hey")) return 1;
  if(!strcmp(s,"sli")) return 1;
  if(!strcmp(s,"hit")) return 1;
  if(!strcmp(s,"mas")) return 1;
  if(!strcmp(s,"shi")) return 1;
  if(!strcmp(s,"has")) return 1;
  if(!strcmp(s,"num")) return 1;
  if(!strcmp(s,"yaj")) return 1;*/
  if(!strcmp(s,"rip")) return 1;
  return 0;
}

char hex(char s) {
  if(s>='0' && s<='9') return s-48;
  if(s>='A' && s<='F') return s-'A'+10;
  if(s>='a' && s<='f') return s-'a'+10;
  return 0;
}

char grabchar(char *p) {
  if(*p!='%') return *p;
  else return hex(*(p+1))*16+hex(*(p+2));
}

#define EAT if(*p=='%') p+=3; else p++;
#define GRAB k=0;while(*p!='+' && *p!='%') t[k++]=*(p++); t[k]=0;

char convtall(int v) {
  if(v<10) return v+48;
  else if(v<36) return v-10+'a';
  else if(v<62) return v-36+'A';
  else {
    printf("too high number (%d)! patch manually\n",v);
    return '?';
  }
}

char convtall0(int v) {
  if(v==0) return '.';
  else if(v<10) return v+48;
  else if(v<36) return v-10+'a';
  else if(v<62) return v-36+'A';
  else {
    printf("too high number (%d)! patch manually\n",v);
    return '?';
  }
}

char *nurikabe(char *t) {
  static char s[1000];
  int v=strtol(t,NULL,10);
  if(v==0) strcpy(s,".");
  else if(v<10) sprintf(s,"%d",v);
  else if(v<36) sprintf(s,"%c",v-10+'a');
  else if(v<62) sprintf(s,"%c",v-36+'A');
  else sprintf(s,"{%d}",v);
  return s;
}

const char *finddata="dataQuestion=";
void parsenurikabe(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata),t[100];
  int i,j,k;
  for(j=0;j<y;j++) {
    for(i=0;i<x;i++) {
      GRAB EAT
      fprintf(f,"%s",nurikabe(t));
    }
    fprintf(f,"\n");
  }
}

char akari(char c) {
  if(c=='X') return '#';
  if(c=='-') return '.';
  if(c>='0' && c<='4') return c;
  printf("ERROR %c\n",c);
  return 0;
}

void parseakari(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  char c;
  int i,j;
  for(j=0;j<y;j++) {
    for(i=0;i<x;i++) {
      c=grabchar(p); EAT EAT
      fprintf(f,"%c",akari(c));
    }
    fprintf(f,"\n");
  }
}

void parseheyawake(FILE *f,int x,int y) {
  static char g[512][512];
  char *p=strstr(buffer,finddata)+strlen(finddata);
  char t[100];
  int i,j,k;
  int v[50],n;
  for(i=0;i<=x*2;i++) for(j=0;j<=y*2;j++) g[i][j]='.';
  while(1) {
    if(*p=='&') break;
    n=0;
    while(*p!='%') {
      GRAB
      v[n]=strtol(t,NULL,10);
      if(n<4) v[n]*=2;
      n++;
      if(*p=='+') p++;
    }
    p+=3;
    g[v[0]][v[1]]='+';
    g[v[0]+v[2]][v[1]]='+';
    g[v[0]][v[1]+v[3]]='+';
    g[v[0]+v[2]][v[1]+v[3]]='+';
    /*  horizontal */
    for(i=v[0]+1;i<v[0]+v[2];i++) {
      if(g[i][v[1]]!='+') g[i][v[1]]='-';
      if(g[i][v[1]+v[3]]!='+') g[i][v[1]+v[3]]='-';
    }
    /*  vertical */
    for(i=v[1]+1;i<v[1]+v[3];i++) {
      if(g[v[0]][i]!='+') g[v[0]][i]='|';
      if(g[v[0]+v[2]][i]!='+') g[v[0]+v[2]][i]='|';
    }
    if(n>4) g[v[0]+1][v[1]+1]=convtall(v[4]);
  }
  for(j=0;j<=y*2;j++) {
    for(i=0;i<=x*2;i++) fprintf(f,"%c",g[i][j]);
    fprintf(f,"\n");
  }
}

void parseslitherlink(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  char c;
  int i,j;
  for(j=0;j<y;j++) {
    EAT
    for(i=0;i<x;i++) {
      c=grabchar(p); EAT EAT
      fprintf(f,"%c",akari(c));
    }
    fprintf(f,"\n");
  }
}

void parsehitori(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  char t[100];
  int i,j,k;
  for(j=0;j<y;j++) {
    EAT
    for(i=0;i<x;i++) {
      GRAB EAT
      fprintf(f,"%c",convtall(strtol(t,NULL,10)));
    }
    fprintf(f,"\n");
  }
}

char masyu(char c) {
  if(c=='0') return '.';
  if(c=='1') return 'o';
  if(c=='2') return '*';
  printf("ERROR masyu %c\n",c);
  return 0;
}

void parsemasyu(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  int i,j;
  for(j=0;j<y;j++) {
    for(i=0;i<x;i++) {
      fprintf(f,"%c",masyu(*p));
      if(i<x-1) p++;
      else p+=4;
    }
    fprintf(f,"\n");
  }
}

void parseshikaku(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  char t[100];
  int i,j,k;
  for(j=0;j<y;j++) {
    for(i=0;i<x;i++) {
      if(*p=='-') {
        fprintf(f,".");
        p++;
      } else {
        GRAB
        fprintf(f,"%c",convtall(strtol(t,NULL,10)));
      }
      EAT
    }
    fprintf(f,"\n");
  }
}

void parsehashiwokakero(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  int i,j;
  for(j=0;j<y;j++) {
    for(i=0;i<x;i++) {
      fprintf(f,"%c",convtall0(*p-48));
      if(i<x-1) p++;
      else p+=4;
    }
    fprintf(f,"\n");
  }
}

void parsenumberlink(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  char t[100];
  int i,j,k,v;
  for(j=0;j<y;j++) {
    EAT
    for(i=0;i<x;i++) {
      GRAB EAT
      v=strtol(t,NULL,10);
      fprintf(f,"%c",convtall0(strtol(t,NULL,10)));
    }
    fprintf(f,"\n");
  }
}

char yajilin(int v) {
  if(v<10) return v+48;
  else if(v<31) return v-10+'a';
  else if(v<35) return v-10+'a'+1;
  else if(v<61) return v-35+'A';
  else {
    printf("too high number (%d)! patch manually\n",v);
    return '?';
  }
}

char yajilindir(char c) {
  if(c=='L') return '<';
  if(c=='R') return '>';
  if(c=='U') return '^';
  if(c=='D') return 'v';
  printf("error yajilin dir %c\n",c);
  return 0;
}

void parseyajilin(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  static char g[512][512];
  int i,j,k,l,dx,dy,antall;
  for(j=0;j<y;j++) for(i=0;i<x;i++) {
    g[i][j]=*p;
    if(i<x-1) p++;
    else p+=4;
  }
  for(j=0;j<y;j++) {
    for(i=0;i<x;i++) {
      if(g[i][j]>='0' && g[i][j]<='9') fprintf(f,"..");
      else {
        dx=dy=0;
        if     (g[i][j]=='L') dx=-1;
        else if(g[i][j]=='R') dx=1;
        else if(g[i][j]=='U') dy=-1;
        else if(g[i][j]=='D') dy=1;
        k=i+dx;
        l=j+dy;
        antall=0;
        while(k>=0 && k<x && l>=0 && l<y) {
          if(g[k][l]=='0') antall++;
          k+=dx;
          l+=dy;
        }
        fprintf(f,"%c%c",yajilin(antall),yajilindir(g[i][j]));
      }
    }
    fprintf(f,"\n");
  }
}

char check(char h[512][512],int a,int b,int x,int y) {
  if(a<0 || b<0 || a>x*2 || b>y*2) return '.';
  if(h[a][b]>='0' && h[a][b]<='9') return '.';
  return h[a][b];
}

void parserippleeffect(FILE *f,int x,int y) {
  char *p=strstr(buffer,finddata)+strlen(finddata);
  static char g[512][512],h[512][512];
  int i,j;
  memset(h,'.',sizeof(h));
  for(j=0;j<y;j++) for(i=0;i<x;i++) {
    g[i][j]=*p;
    if(i<x-1) p++;
    else p+=4;
  }
  h[0][0]='+';
  h[2*x][0]='+';
  h[0][2*y]='+';
  h[2*x][2*y]='+';
  for(i=1;i<=x*2;i+=2) h[i][0]=h[i][y*2]='-';
  for(j=1;j<=y*2;j+=2) h[0][j]=h[x*2][j]='|';
  for(j=0;j<y;j++) {
    for(i=0;i<x;i++) {
      if(*p=='0') h[i*2+1][j*2+1]='.';
      else h[i*2+1][j*2+1]=*p;
      if(i<x-1) p++;
      else p+=4;
      if(i<x-1 && g[i][j]!=g[i+1][j]) h[i*2+2][j*2+1]='|';
      if(j<y-1 && g[i][j]!=g[i][j+1]) h[i*2+1][j*2+2]='-';
    }
  }
  for(i=0;i<=x*2;i+=2) for(j=0;j<=y*2;j+=2) {
    if(check(h,i-1,j,x,y)=='.' && check(h,i+1,j,x,y)=='.' && check(h,i,j+1,x,y)=='|' && check(h,i,j-1,x,y)=='|') h[i][j]='|';
    else if(check(h,i-1,j,x,y)=='-' && check(h,i+1,j,x,y)=='-' && check(h,i,j+1,x,y)=='.' && check(h,i,j-1,x,y)=='.') h[i][j]='-';
    else if(check(h,i-1,j,x,y)!='.' || check(h,i+1,j,x,y)!='.' || check(h,i,j+1,x,y)!='.' || check(h,i,j-1,x,y)!='.') h[i][j]='+';
  }
  for(j=0;j<y*2+1;j++) {
    for(i=0;i<x*2+1;i++) fprintf(f,"%c",h[i][j]);
    fprintf(f,"\n");
  }
}

void grabandsavepuzzle(char *s,char *firstline,char *p3,char *puzzle,char *difficulty) {
  const char *findsize="dataSize=";
  char *p;
  int x,y;
  FILE *f;
  p=strstr(buffer,findsize)+strlen(findsize);
  sscanf(p,"%d+%d",&x,&y);
  if(!(f=fopen(s,"w"))) {
    printf("error, couldn't save file %s.\n",s);
    return;
  }
  fprintf(f,"%s\n%s\n%s\n%d %d\n",firstline,puzzle,difficulty,x,y);
  if(!strcmp(p3,"nur")) parsenurikabe(f,x,y);
  if(!strcmp(p3,"aka")) parseakari(f,x,y);
  if(!strcmp(p3,"hey")) parseheyawake(f,x,y);
  if(!strcmp(p3,"sli")) parseslitherlink(f,x,y);
  if(!strcmp(p3,"hit")) parsehitori(f,x,y);
  if(!strcmp(p3,"mas")) parsemasyu(f,x,y);
  if(!strcmp(p3,"shi")) parseshikaku(f,x,y);
  if(!strcmp(p3,"has")) parsehashiwokakero(f,x,y);
  if(!strcmp(p3,"num")) parsenumberlink(f,x,y);
  if(!strcmp(p3,"yaj")) parseyajilin(f,x,y);
  if(!strcmp(p3,"rip")) parserippleeffect(f,x,y);
  fclose(f);
}

void processchamp() {
  const char *champmatch="<tr><td>Vol.",*findpuzzle="alt=\"Try ",*findpuzzle2="class=\"puzzle\">";
  const char *findauthor="</span></p></td><td>",*finddifficulty="<p><span>",*finddata="swf?loadUrl=";
  char *p=buffer,p3[4],puzzle[100],*q,term,author[100],diff[100],s[100],url[100],t[1000];
  int id,i,j;
  puts("start grabbing championship puzzles!");
  num=0;
  while((p=strstr(p,champmatch))) {
    p=q=p+strlen(champmatch);
    id=strtol(q,NULL,10);
    if(taken[id]) continue;
    taken[id]=1;
    if((q=strstr(p,findpuzzle))) {
      q+=strlen(findpuzzle);
      term=' ';
    } else {
      q=strstr(p,findpuzzle2);
      if(!q) return;
      q+=strlen(findpuzzle2);
      term='<';
    }
    for(i=0;i<3;i++) p3[i]=tolower(q[i]);
    for(i=0;q[i]!=term;i++) puzzle[i]=tolower(q[i]);
    puzzle[i]=p3[3]=0;
    if(!supported(p3)) continue;
    sprintf(s,"%sC%03d.txt",p3,id);
    if(fileexists(s)) continue;
    q=strstr(p,findauthor)+strlen(findauthor);
    for(i=0;q[i]!='<';i++) author[i]=q[i];
    author[i]=0;
    q=strstr(p,finddifficulty)+strlen(finddifficulty);
    for(i=0;q[i]!='<';i++) diff[i]=tolower(q[i]);
    diff[i]=0;
    printf("puzzle number %d: %s by %s, difficulty %s\n",id,puzzle,author,diff);
    q=strstr(p,finddata)+strlen(finddata);
    strcpy(url,"http://www.nikoli.com");
    for(i=0,j=strlen(url);q[i]!='&';i++,j++) url[j]=q[i];
    url[j]=0;
    loadwebpage(url);
    sprintf(t,"%% %s puzzle championship vol.%d nikoli by %s",puzzle,id,author);
    grabandsavepuzzle(s,t,p3,puzzle,diff);
    p=q;
    num++;
  }
}

void processsample() {
  const char *samplematch="<br />Sample problem",*findpuzzle="Sample problems of ";
  const char *findauthor="</p></td><td>",*finddifficulty="\"><p>",*finddata="swf?loadUrl=";
  char *p=buffer,*q,p3[4],puzzle[100],author[100],diff[100],s[100],url[100],t[1000];
  int id,i,j;
  p=strstr(p,findpuzzle);
  p+=strlen(findpuzzle);
  for(i=0;i<3;i++) p3[i]=tolower(p[i]);
  for(i=0;p[i]!=' ';i++) puzzle[i]=tolower(p[i]);
  puzzle[i]=p3[3]=0;
  if(!supported(p3)) {
    printf("no support for %s, yet\n",puzzle);
    return;
  }
  printf("start grabbing samples of %s!\n",puzzle);
  num=0;
  while((p=strstr(p,samplematch))) {
    q=p+strlen(samplematch);
    id=strtol(q,NULL,10);
    if(taken[id]) { p=q; continue; }
    sprintf(s,"%sS%02d.txt",p3,id);
    if(fileexists(s)) { p=q; continue; }
    q=strstr(p,findauthor)+strlen(findauthor);
    for(i=0;q[i]!='<';i++) author[i]=q[i];
    author[i]=0;
    q=strstr(p,finddifficulty)+strlen(finddifficulty);
    for(i=0;q[i]!='<';i++) diff[i]=tolower(q[i]);
    diff[i]=0;
    printf("sample puzzle %d by %s, difficulty %s\n",id,author,diff);
    q=strstr(p,finddata)+strlen(finddata);
    strcpy(url,"http://www.nikoli.com");
    for(i=0,j=strlen(url);q[i]!='&';i++,j++) url[j]=q[i];
    url[j]=0;
    if(url[j-4]=='h' && url[j-3]=='i' && url[j-2]=='s' && url[j-1]=='t') url[j-5]=0;
    loadwebpage(url);
    sprintf(t,"%% %s, nikoli sample problem %d by %s",puzzle,id,author);
    grabandsavepuzzle(s,t,p3,puzzle,diff);
    p=q;
    num++;
  }
}

int main(int argc,char**argv) {
  puts("puzzle grabber v0.1\n");
  if(argc<2) {
    puts("usage: grab website");
    exit(0);
  }
  loadwebpage(argv[1]);
  strcpy(buf2,buffer);
  if(strstr(buffer,"Sample problems")) processsample();
  else processchamp();
  printf("done! grabbed %d puzzles\n",num);
  return 0;
}
