#ifndef PUZZLE_H
#define PUZZLE_H

#include "sdlfont.h"

typedef unsigned char uchar;

/*  events */
#define EVENT_NOEVENT   -1
#define EVENT_KEYDOWN   0
#define EVENT_KEYUP     512
#define EVENT_MOUSEDOWN 1024
#define EVENT_MOUSEUP   2048
#define EVENT_RESIZE    65536
#define EVENT_QUIT      131072

/*  colours */
#define WHITE8          255
#define BLACK8          0
#define YELLOW8         0xFC
#define GREEN8          0x1C
#define RED8            0xEC
#define DARKBLUE8       2
#define BLUE8           3
#define GRAY8           0xB6
#define GRAYBLUE8       0xB7
#define DARKRED8        224
#define DARKERRED8      128

/*  global variables (from graphic, mainly) */
extern int keys[512];
extern int resx,resy;
extern int thick;
extern int thin;
extern double aspectratio;
extern SDL_Surface *screen;
extern sdl_font *font;

extern int heyawakethick;

extern int controlscheme_nurikabe;
extern int controlscheme_akari;
extern int controlscheme_heyawake;
extern int controlscheme_hitori;
extern int controlscheme_picross;

extern uchar unfilledcol;
extern uchar mustprocesscol;
extern uchar filledcol;
extern uchar filled2col;
extern uchar blankcol;
extern uchar okcol;
extern uchar almostokcol;
extern uchar errorcol;
extern uchar darkerrorcol;
extern uchar darkererrorcol;
extern uchar lightcol;

extern int undokey;
extern int hintkey;
extern int verifykey;

extern int width,height;
extern int startx,starty;

extern int event_mousebutton;
extern int event_mousex;
extern int event_mousey;

extern int dx[],dy[],dx8[],dy8[];

/*  system stuff */
void error(char *,...);
void logprintf(char *,...);
void resetlog();

/*  init/shutdown */
void initgr();
void shutdown();

/*  non-graphic helper stuff */
void updatescale(int,int,int,int,int);
void getcell(int,int,int *,int *);
int manhattandist(int,int,int,int);

/*  graphics routines */
void clear8(uchar);
void palette8();
void drawrectangle8(int,int,int,int,Uint8);
void drawhorizontalline8(int,int,int,Uint8);
void drawsolidcell8(int,int,Uint8);
void drawsolidcell8w(int,int,Uint8,int,int,int,int);
void drawnumbercell8(int,int,int,Uint8,Uint8,Uint8);
void drawnumbercell8w(int,int,int,Uint8,Uint8,Uint8,int,int,int,int);
void drawdisc(int,int,double,Uint8,Uint8);

void sdlrefreshcell(int,int);

void messagebox(char *,...);

/*  stack */

void stackpush(int);
int stackempty();
int stackpop();
int getstackpos();
void setstackpos(int);

/*  events */
int getevent();
void anykeypress();

/*  entry point for every game */
void nurikabe(char *);
void akari(char *);
void heyawake(char *);
void hitori(char *);
void picross(char *);

#endif  /*  PUZZLE_H */
