/* small program that extracts credits from a bunch of puzzle files */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "dir.h"

char list[100000][200];
int n;

static int ispuzzle(char *s) {
	if(strlen(s)>2 && !strncmp(s,"aka",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"has",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"hey",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"hit",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"kur",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"mas",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"min",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"nur",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"pic",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"sli",3)) return 1;
	if(strlen(s)>2 && !strncmp(s,"yaj",3)) return 1;
	return 0;
}

static void strip(char *s) {
	int n;
	n=strlen(s);
	while(n && (s[n-1]=='\n' || s[n-1]=='\r')) s[--n]=0;
}

int comps(const void *A,const void *B) {
	char *a=(char *)A,*b=(char *)B;
	return strcmp(a,b);
}

int main(int argc,char **argv) {
	static char s[1000000];
	static char name[1000];
	FILE *f;
	dir_t dir;
	int i,j;
	n=0;
	/* path to puzzles */
	if(!findfirst("temp/*.txt",&dir)) {
		printf("error, no files found\n");
		return 0;
	}
	do {
		if(dir.dir>0) continue;
		if(!strcmp(dir.s,".") || !strcmp(dir.s,"..")) continue;
		if(!ispuzzle(dir.s)) continue;
		if(strlen(dir.s)>50) continue;
		/* path again */
		strcpy(name,"temp/");
		strcat(name,dir.s);
		f=fopen(name,"r");
		if(f) {
			fgets(s,999999,f);
			strip(s);
			/* extract author: search for "by" and grab until next
			   non-alphanumeric character or EOL */
			for(i=0;s[i];i++) if(s[i]=='b' && s[i+1]=='y') {
				i+=2;
				while(s[i] && isspace(s[i])) i++;
				j=0;
				while(s[i] && (s[i]==' ' || isalnum(s[i]))) name[j++]=s[i++];
				name[j]=0;
				if(j>199) printf("error %s\n",s);
				else strcpy(list[n++],name);
				goto done;
			}
			printf("[%s], no author found\n",s);
		done:
			fclose(f);
		} else printf("error, couldn't open [%s]\n",name);
	} while(findnext(&dir));
	qsort(list,n,200,comps);
	for(i=j=1;i<n;i++) if(strcmp(list[i-1],list[i])) strcpy(list[j++],list[i]);
	n=j;
	for(i=0;i<n;i++) printf("%s\n",list[i]);
	return 0;
}
